/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.interfaces;

import java.io.InputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import net.skinsrestorer.api.interfaces.ISRPlayer;
import net.skinsrestorer.shadow.aikar.commands.CommandManager;
import net.skinsrestorer.shared.commands.ISkinCommand;
import net.skinsrestorer.shared.storage.SkinStorage;
import net.skinsrestorer.shared.utils.CommandPropertiesManager;
import net.skinsrestorer.shared.utils.CommandReplacements;
import net.skinsrestorer.shared.utils.MetricsCounter;
import net.skinsrestorer.shared.utils.SharedMethods;
import net.skinsrestorer.shared.utils.connections.MojangAPI;
import net.skinsrestorer.shared.utils.log.SRLogger;

public interface ISRPlugin {
    public Path getDataFolderPath();

    public SkinStorage getSkinStorage();

    public String getVersion();

    public MetricsCounter getMetricsCounter();

    public SRLogger getSrLogger();

    public InputStream getResource(String var1);

    public void runAsync(Runnable var1);

    public Collection<ISRPlayer> getOnlinePlayers();

    public ISkinCommand getSkinCommand();

    default public void prepareACF(CommandManager<?, ?, ?, ?, ?, ?> manager, SRLogger srLogger) {
        manager.enableUnstableAPI("help");
        CommandReplacements.permissions.forEach((k, v) -> manager.getCommandReplacements().addReplacement((String)k, (String)v.call()));
        CommandReplacements.descriptions.forEach((k, v) -> manager.getCommandReplacements().addReplacement((String)k, (String)v.call()));
        CommandReplacements.syntax.forEach((k, v) -> manager.getCommandReplacements().addReplacement((String)k, (String)v.call()));
        CommandReplacements.completions.forEach((k, v) -> manager.getCommandCompletions().registerAsyncCompletion((String)k, c -> Arrays.asList(((String)v.call()).split(", "))));
        CommandPropertiesManager.load(manager, this.getDataFolderPath(), this.getResource("command-messages.properties"), srLogger);
        SharedMethods.allowIllegalACFNames();
    }

    public CommandManager<?, ?, ?, ?, ?, ?> getManager();

    public MojangAPI getMojangAPI();
}

